#ifndef _HEADERS_DEFINITIONS_H
#define _HEADERS_DEFINITIONS_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define TitleCaption "SQL-Exchange Client"
#define FileVersion  "1.0.1.8"
#define RegistryKey  "Software\\Ingenuity Software, Corp.\\SQL-Exchange\\Client"  

#define AUTH_CMD_FAILED     1
#define AUTH_CMD_OK         2
#define AUTH_CMD_SUCCESS    3
#define AUTH_CMD_DISCONNECT 4
#define AUTH_CMD_UNKNOWN    5

#define COMMAND_RESULT_DISCONNECT 1
#define COMMAND_RESULT_OK         2
#define COMMAND_RESULT_ERROR      3
#define COMMAND_RESULT_UNKNOWN    4

#define SQL_IMPORT_RESULT_OK       1
#define SQL_IMPORT_RESULT_ERROR    2
#define SQL_IMPORT_RESULT_ZEROROWS 3

//---------------------(Instance Definitions & Dialog Handle Definitions)
HINSTANCE MainInstance = NULL; // WinMain (Application) Instance
HWND MainDialog_hWnd   = NULL;

//---------------------(Global Variables)

bool gbApplicationRunning = false;
bool gbConnectNow = false;
bool gbIsClientDialogOpen = false;
bool gbKillApplication = false;

char gsAdminPassword[64];
char gsAuthString[1024];
char gsBaseCommKey[1024];
char gsCompanyName[64];
char gsCompanyPassword[64];    
char gsImportTable[64];
char gsLocalCryptKey[1024];
char gsPath[256];
char gsSessionLogDir[256];
char gsSQLDatabase[256];
char gsSQLDriver[256];
char gsSQLExportTempFile[256];
char gsSQLPassword[256];
char gsSQLServer[256];
char gsSQLUserID[256];
char gsWPServer[256];

DWORD glConnectInterval = 0;
DWORD glConnectPort = 0;
DWORD glDataCRC = 0;
DWORD glErrorCount = 0;    // User Interface Status
DWORD glTCPLoopDelay = 0;
DWORD glTotalConnects = 0; // User Interface Status
DWORD glWarningCount = 0;  // User Interface Status

FILE *gfSessionLog = NULL;

struct _MainDialogInfo{
    HWND RecvEdit_hWnd;
}; _MainDialogInfo MDI;

//---------------------(Dialog Prototypes)
BOOL CALLBACK MainDialog(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK SplashDialog(HWND, UINT, WPARAM, LPARAM);

//---------------------(Function Prototypes)
bool ClientSend(char *, int);
bool ConnectAndBeginTransaction(void);
bool DoConnect(void);
bool DoDisconnect(void);
bool GetRegistryValues(void);
bool InitCryptography(void);
bool Initialize(void);
bool OpenLogFile(void);
bool SaveRegistryValues(void);
bool SendFileData(char *);
bool SimpleClientSend(char *);
bool UninitCryptography(void);
bool Uninitialize(void);
bool WaitOnApplicationToExit(void);
bool xMainEntry(void);

int AuthenticateWithServer(void);
int AuthProcessCommand(char *, int);
int ExportSQLResults(char *, char *, char *, char *, char *, char *, char *, char *);
int ProcessCommand(char *, int);

SQLINTEGER CharTrim(SQLCHAR *, SQLINTEGER);

void FatalError(char *);
void ReplaceSingleQuotes(SQLCHAR *, SQLINTEGER);
void WriteLog(char *);
void WriteNull(FILE *);

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif



